/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.block.inv.SlotCropSeed;
import net.darkhax.botanypots.block.inv.SlotPotOutput;
import net.darkhax.botanypots.block.inv.SlotSoil;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public class BotanyPotMenu
extends class_1703 {
    private static final CachedSupplier<class_3917<?>> MENU_TYPE = CachedSupplier.cache(() -> (class_3917)class_2378.field_17429.method_10223(new class_2960("botanypots", "pot_menu")));
    private final BotanyPotContainer potInv;
    private final class_1661 playerInv;

    public static BotanyPotMenu fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        class_2338 tilePos = (class_2338)Serializers.BLOCK_POS.fromByteBuf(buf);
        class_2586 class_25862 = inv.field_7546.field_6002.method_8321(tilePos);
        if (class_25862 instanceof BlockEntityBotanyPot) {
            BlockEntityBotanyPot pot = (BlockEntityBotanyPot)class_25862;
            return new BotanyPotMenu(windowId, (BotanyPotContainer)pot.getInventory(), inv);
        }
        Constants.LOG.error("Attempted to open botany pot at invalid position {}.", (Object)tilePos);
        throw new IllegalStateException("Attempted to open botany pot at invalid position " + tilePos);
    }

    public BotanyPotMenu(int id, BotanyPotContainer potInv, class_1661 playerInv) {
        super((class_3917)MENU_TYPE.get(), id);
        this.potInv = potInv;
        this.playerInv = playerInv;
        int slotXOffset = this.isHopper() ? 44 : 80;
        this.method_7621(new SlotSoil((class_1263)potInv, 0, slotXOffset, 48, this.potInv.getPotEntity()::isValidSoil));
        this.method_7621(new SlotCropSeed((class_1263)potInv, 1, slotXOffset, 22, this.potInv.getPotEntity()::isValidSeed));
        if (this.isHopper()) {
            for (int potOutputY = 0; potOutputY < 3; ++potOutputY) {
                for (int potOutputX = 0; potOutputX < 4; ++potOutputX) {
                    int slotId = potOutputX + potOutputY * 4 + 2;
                    int slotX = 80 + potOutputX * 18;
                    int slotY = 17 + potOutputY * 18;
                    this.method_7621(new SlotPotOutput((class_1263)potInv, slotId, slotX, slotY));
                }
            }
        }
        for (int playerInvY = 0; playerInvY < 3; ++playerInvY) {
            for (int playerInvX = 0; playerInvX < 9; ++playerInvX) {
                this.method_7621(new class_1735((class_1263)playerInv, playerInvX + playerInvY * 9 + 9, 8 + playerInvX * 18, 84 + playerInvY * 18));
            }
        }
        for (int hotbarX = 0; hotbarX < 9; ++hotbarX) {
            this.method_7621(new class_1735((class_1263)playerInv, hotbarX, 8 + hotbarX * 18, 142));
        }
    }

    public class_1799 method_7601(class_1657 player, int slotId) {
        BlockEntityBotanyPot pot = this.potInv.getPotEntity();
        class_1937 level = pot.method_10997();
        class_2338 pos = pot.method_11016();
        class_1735 slot = (class_1735)this.field_7761.get(slotId);
        int firstSlot = this.isHopper() ? 14 : 2;
        int lastSlot = this.isHopper() ? 50 : 38;
        class_1799 unmovedItems = class_1799.field_8037;
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            unmovedItems = slotStack.method_7972();
            if (this.isHopper() && slotId >= 2 && slotId <= 13) {
                if (!this.method_7616(slotStack, firstSlot, lastSlot, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(slotStack, unmovedItems);
            } else if (slotId == 0 || slotId == 1) {
                if (!this.method_7616(slotStack, firstSlot, lastSlot, true)) {
                    return class_1799.field_8037;
                }
            } else if (slotId >= firstSlot && slotId <= lastSlot) {
                class_1735 cropSlot;
                class_1735 soilSlot = (class_1735)this.field_7761.get(0);
                if (!soilSlot.method_7681() && BotanyPotHelper.findSoil(level, pos, pot, slotStack) != null) {
                    soilSlot.method_7673(slotStack.method_7971(1));
                    slot.method_7673(slotStack);
                    if (slotStack.method_7960()) {
                        return class_1799.field_8037;
                    }
                }
                if (!(cropSlot = (class_1735)this.field_7761.get(1)).method_7681() && BotanyPotHelper.findCrop(level, pos, pot, slotStack) != null) {
                    cropSlot.method_7673(slotStack.method_7971(1));
                    slot.method_7673(slotStack);
                    if (slotStack.method_7960()) {
                        return class_1799.field_8037;
                    }
                }
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == unmovedItems.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
        }
        return unmovedItems;
    }

    public boolean isHopper() {
        return this.potInv.getPotEntity().isHopper();
    }

    public boolean method_7597(class_1657 player) {
        return this.potInv.method_5443(player);
    }

    public BotanyPotContainer getPotInventory() {
        return this.potInv;
    }
}

